/*
 * File: Foreach.java
 * ===================================================
 * A program that shows off iteration in Java.
 */

import acm.program.*;
import java.util.*;

public class ForEach extends ConsoleProgram {
	public void run() {
		/* Iteration is useless if we can't see it!*/
		setFont("DejaVuSerif-24-BOLD");
		
		/* Load up a HashMap with some "interesting" Strings. */
		HashMap<String, Integer> myMap = new HashMap<String, Integer>();
		myMap.put("Jeremy Keeshin", 0);
		myMap.put("CS106A", 1);
		myMap.put("Nubian Ibex", 2);
		myMap.put("Karel the Robot", 3);
		
		/* Print out the HashMap! */
		for (String key: myMap.keySet()) {
			println(key + ": " + myMap.get(key));
		}
		
		/* Load up an ArrayList<String> with some text. */
		ArrayList<String> myList = new ArrayList<String>();
		myList.add("Preantepenultimate string");
		myList.add("Antepenultimate string");
		myList.add("Penultimate string");
		myList.add("Ultimate string");
		
		/* Use a foreach loop to print it out. */
		for (String str: myList) {
			println(str);
		}
	}
}
